* [做项目（多个C++、Java、Go、测开、前端项目）](https://www.programmercarl.com/other/kstar.html)
* [刷算法（两个月高强度学算法）](https://www.programmercarl.com/xunlian/xunlianying.html)
* [背八股（40天挑战高频面试题）](https://www.programmercarl.com/xunlian/bagu.html)

# 309.最佳买卖股票时机含冷冻期

[力扣题目链接](https://leetcode.cn/problems/best-time-to-buy-and-sell-stock-with-cooldown/)

给定一个整数数组，其中第 i 个元素代表了第 i 天的股票价格 。

设计一个算法计算出最大利润。在满足以下约束条件下，你可以尽可能地完成更多的交易（多次买卖一支股票）:

* 你不能同时参与多笔交易（你必须在再次购买前出售掉之前的股票）。
* 卖出股票后，你无法在第二天买入股票 (即冷冻期为 1 天)。

示例:
* 输入: [1,2,3,0,2]
* 输出: 3
* 解释: 对应的交易状态为: [买入, 卖出, 冷冻期, 买入, 卖出]

## 算法公开课

**[《代码随想录》算法视频公开课](https://programmercarl.com/other/gongkaike.html)：[动态规划来决定最佳时机，这次有冷冻期！| LeetCode：309.买卖股票的最佳时机含冷冻期](https://www.bilibili.com/video/BV1rP4y1D7ku)，相信结合视频再看本篇题解，更有助于大家对本题的理解**。


## 思路


相对于[动态规划：122.买卖股票的最佳时机II](https://programmercarl.com/0122.买卖股票的最佳时机II（动态规划）.html)，本题加上了一个冷冻期


在[动态规划：122.买卖股票的最佳时机II](https://programmercarl.com/0122.买卖股票的最佳时机II（动态规划）.html) 中有两个状态，持有股票后的最多现金，和不持有股票的最多现金。

动规五部曲，分析如下：

1. 确定dp数组以及下标的含义

dp[i][j]，第i天状态为j，所剩的最多现金为dp[i][j]。

**其实本题很多同学搞的比较懵，是因为出现冷冻期之后，状态其实是比较复杂度**，例如今天买入股票、今天卖出股票、今天是冷冻期，都是不能操作股票的。

具体可以区分出如下四个状态：

* 状态一：持有股票状态（今天买入股票，或者是之前就买入了股票然后没有操作，一直持有）
* 不持有股票状态，这里就有两种卖出股票状态
    * 状态二：保持卖出股票的状态（两天前就卖出了股票，度过一天冷冻期。或者是前一天就是卖出股票状态，一直没操作）
    * 状态三：今天卖出股票
* 状态四：今天为冷冻期状态，但冷冻期状态不可持续，只有一天！

![](https://file1.kamacoder.com/i/algo/518d5baaf33f4b2698064f8efb42edbf.png)

j的状态为：

* 0：状态一
* 1：状态二
* 2：状态三
* 3：状态四

很多题解为什么讲的比较模糊，是因为把这四个状态合并成三个状态了，其实就是把状态二和状态四合并在一起了。

从代码上来看确实可以合并，但从逻辑上分析合并之后就很难理解了，所以我下面的讲解是按照这四个状态来的，把每一个状态分析清楚。

如果大家按照代码随想录顺序来刷的话，会发现 买卖股票最佳时机 1，2，3，4 的题目讲解中 

* [动态规划：121.买卖股票的最佳时机](https://programmercarl.com/0121.买卖股票的最佳时机.html)
* [动态规划：122.买卖股票的最佳时机II](https://programmercarl.com/0122.买卖股票的最佳时机II（动态规划）.html)
* [动态规划：123.买卖股票的最佳时机III](https://programmercarl.com/0123.买卖股票的最佳时机III.html)
* [动态规划：188.买卖股票的最佳时机IV](https://programmercarl.com/0188.买卖股票的最佳时机IV.html)

「今天卖出股票」我是没有单独列出一个状态的归类为「不持有股票的状态」，而本题为什么要单独列出「今天卖出股票」 一个状态呢？ 

因为本题我们有冷冻期，而冷冻期的前一天，只能是 「今天卖出股票」状态，如果是 「不持有股票状态」那么就很模糊，因为不一定是 卖出股票的操作。 

如果没有按照 代码随想录 顺序去刷的录友，可能看这里的讲解 会有点困惑，建议把代码随想录本篇之前股票内容的讲解都看一下，领会一下每天 状态的设置。 

**注意这里的每一个状态，例如状态一，是持有股票股票状态并不是说今天一定就买入股票，而是说保持买入股票的状态即：可能是前几天买入的，之后一直没操作，所以保持买入股票的状态**。

1. 确定递推公式

**达到买入股票状态**（状态一）即：dp[i][0]，有两个具体操作：

* 操作一：前一天就是持有股票状态（状态一），dp[i][0] = dp[i - 1][0]
* 操作二：今天买入了，有两种情况
    * 前一天是冷冻期（状态四），dp[i - 1][3] - prices[i]
    * 前一天是保持卖出股票的状态（状态二），dp[i - 1][1] - prices[i]

那么dp[i][0] = max(dp[i - 1][0], dp[i - 1][3] - prices[i], dp[i - 1][1] - prices[i]);

**达到保持卖出股票状态**（状态二）即：dp[i][1]，有两个具体操作：

* 操作一：前一天就是状态二
* 操作二：前一天是冷冻期（状态四）

dp[i][1] = max(dp[i - 1][1], dp[i - 1][3]);

**达到今天就卖出股票状态**（状态三），即：dp[i][2] ，只有一个操作：

昨天一定是持有股票状态（状态一），今天卖出

即：dp[i][2] = dp[i - 1][0] + prices[i];

**达到冷冻期状态**（状态四），即：dp[i][3]，只有一个操作：

昨天卖出了股票（状态三）

dp[i][3] = dp[i - 1][2];

综上分析，递推代码如下：

```CPP
dp[i][0] = max(dp[i - 1][0], max(dp[i - 1][3], dp[i - 1][1]) - prices[i]);
dp[i][1] = max(dp[i - 1][1], dp[i - 1][3]);
dp[i][2] = dp[i - 1][0] + prices[i];
dp[i][3] = dp[i - 1][2];
```

3.  dp数组如何初始化

这里主要讨论一下第0天如何初始化。

如果是持有股票状态（状态一）那么：dp[0][0] = -prices[0]，一定是当天买入股票。

保持卖出股票状态（状态二），这里其实从 「状态二」的定义来说 ，很难明确应该初始多少，这种情况我们就看递推公式需要我们给他初始成什么数值。 

如果i为1，第1天买入股票，那么递归公式中需要计算   dp[i - 1][1] - prices[i] ，即 dp[0][1] - prices[1]，那么大家感受一下 dp[0][1] （即第0天的状态二）应该初始成多少，只能初始为0。想一想如果初始为其他数值，是我们第1天买入股票后 手里还剩的现金数量是不是就不对了。

今天卖出了股票（状态三），同上分析，dp[0][2]初始化为0，dp[0][3]也初始为0。


4. 确定遍历顺序

从递归公式上可以看出，dp[i] 依赖于 dp[i-1]，所以是从前向后遍历。

5. 举例推导dp数组

以 [1,2,3,0,2] 为例，dp数组如下：


![309.最佳买卖股票时机含冷冻期](https://file1.kamacoder.com/i/algo/2021032317451040.png)

最后结果是取 状态二，状态三，和状态四的最大值，不少同学会把状态四忘了，状态四是冷冻期，最后一天如果是冷冻期也可能是最大值。

代码如下：

```CPP
class Solution {
public:
    int maxProfit(vector<int>& prices) {
        int n = prices.size();
        if (n == 0) return 0;
        vector<vector<int>> dp(n, vector<int>(4, 0));
        dp[0][0] -= prices[0]; // 持股票
        for (int i = 1; i < n; i++) {
            dp[i][0] = max(dp[i - 1][0], max(dp[i - 1][3] - prices[i], dp[i - 1][1] - prices[i]));
            dp[i][1] = max(dp[i - 1][1], dp[i - 1][3]);
            dp[i][2] = dp[i - 1][0] + prices[i];
            dp[i][3] = dp[i - 1][2];
        }
        return max(dp[n - 1][3], max(dp[n - 1][1], dp[n - 1][2]));
    }
};
```

* 时间复杂度：O(n)
* 空间复杂度：O(n)

当然，空间复杂度可以优化，定义一个dp[2][4]大小的数组就可以了，就保存前一天的当前的状态，感兴趣的同学可以自己去写一写，思路是一样的。

## 总结

这次把冷冻期这道题目，讲的很透彻了，细分为四个状态，其状态转移也十分清晰，建议大家都按照四个状态来分析，如果只划分三个状态确实很容易给自己绕进去。

## 其他语言版本

### Java：

```java
class Solution {
    public int maxProfit(int[] prices) {
        if (prices == null || prices.length < 2) {
            return 0;
        }
        int[][] dp = new int[prices.length][2];

        // bad case
        dp[0][0] = 0;
        dp[0][1] = -prices[0];
        dp[1][0] = Math.max(dp[0][0], dp[0][1] + prices[1]);
        dp[1][1] = Math.max(dp[0][1], -prices[1]);

        for (int i = 2; i < prices.length; i++) {
            // dp公式
            dp[i][0] = Math.max(dp[i - 1][0], dp[i - 1][1] + prices[i]);
            dp[i][1] = Math.max(dp[i - 1][1], dp[i - 2][0] - prices[i]);
        }

        return dp[prices.length - 1][0];
    }
}
```
```java
//using 2*4 array for space optimization
//這裡稍微說一下，我在LeetCode提交的時候，2*4 2-D array的performance基本上和下面的1-D array performance差不多
//都是time: 1ms, space: 40.X MB （其實 length*4 的 2-D array也僅僅是space:41.X MB，看起來不多）
//股票累的DP題目大致上都是這樣，就當作是一個延伸就好了。真的有人問如何優化，最起碼有東西可以講。
class Solution {
    /**
    1. [i][0] holding the stock
    2. [i][1] after cooldown but stil not buing the stock
    3. [i][2] selling the stock
    4. [i][3] cooldown
     */
    public int maxProfit(int[] prices) {
        int len = prices.length;
        int dp[][] = new int [2][4];
        dp[0][0] = -prices[0];
        
        for(int i = 1; i < len; i++){
            dp[i % 2][0] = Math.max(Math.max(dp[(i - 1) % 2][0], dp[(i - 1) % 2][1] - prices[i]), dp[(i - 1) % 2][3] - prices[i]);
            dp[i % 2][1] = Math.max(dp[(i - 1) % 2][1], dp[(i - 1) % 2][3]);
            dp[i % 2][2] = dp[(i - 1) % 2][0] + prices[i];
            dp[i % 2][3] = dp[(i - 1) % 2][2];
        }
        return Math.max(Math.max(dp[(len - 1) % 2][1], dp[(len - 1) % 2][2]), dp[(len - 1) % 2][3]);
    }
}
```
```java
// 一维数组优化
class Solution {
    public int maxProfit(int[] prices) {
        int[] dp=new int[4];

        dp[0] = -prices[0];
        dp[1] = 0;
        for(int i = 1; i <= prices.length; i++){
          	// 使用临时变量来保存dp[0], dp[2]
            // 因为马上dp[0]和dp[2]的数据都会变 
            int temp = dp[0];
            int temp1 = dp[2];
            dp[0] = Math.max(dp[0], Math.max(dp[3], dp[1]) - prices[i]);
            dp[1] = Math.max(dp[1], dp[3]);
            dp[2] = temp + prices[i];
            dp[3] = temp1;
        }
        return Math.max(dp[3],Math.max(dp[1],dp[2]));
    }
}
```
```java
//另一种解题思路
class Solution {
    public int maxProfit(int[] prices) {
        int[][] dp = new int[prices.length + 1][2];
        dp[1][0] = -prices[0];

        for (int i = 2; i <= prices.length; i++) {
            /*
            dp[i][0] 第i天持有股票收益;
            dp[i][1] 第i天不持有股票收益;
            情况一：第i天是冷静期，不能以dp[i-1][1]购买股票,所以以dp[i - 2][1]买股票，没问题
            情况二：第i天不是冷静期，理论上应该以dp[i-1][1]购买股票，但是第i天不是冷静期说明，第i-1天没有卖出股票，
                则dp[i-1][1]=dp[i-2][1],所以可以用dp[i-2][1]买股票，没问题
             */
            dp[i][0] = Math.max(dp[i - 1][0], dp[i - 2][1] - prices[i - 1]);
            dp[i][1] = Math.max(dp[i - 1][1], dp[i - 1][0] + prices[i - 1]);
        }

        return dp[prices.length][1];
    }
}
```

### Python：
> 版本一

```python
from typing import List

class Solution:
    def maxProfit(self, prices: List[int]) -> int:
        n = len(prices)
        if n == 0:
            return 0
        dp = [[0] * 4 for _ in range(n)]  # 创建动态规划数组，4个状态分别表示持有股票、不持有股票且处于冷冻期、不持有股票且不处于冷冻期、不持有股票且当天卖出后处于冷冻期
        dp[0][0] = -prices[0]  # 初始状态：第一天持有股票的最大利润为买入股票的价格
        for i in range(1, n):
            dp[i][0] = max(dp[i-1][0], max(dp[i-1][3], dp[i-1][1]) - prices[i])  # 当前持有股票的最大利润等于前一天持有股票的最大利润或者前一天不持有股票且不处于冷冻期的最大利润减去当前股票的价格
            dp[i][1] = max(dp[i-1][1], dp[i-1][3])  # 当前不持有股票且处于冷冻期的最大利润等于前一天持有股票的最大利润加上当前股票的价格
            dp[i][2] = dp[i-1][0] + prices[i]  # 当前不持有股票且不处于冷冻期的最大利润等于前一天不持有股票的最大利润或者前一天处于冷冻期的最大利润
            dp[i][3] = dp[i-1][2]  # 当前不持有股票且当天卖出后处于冷冻期的最大利润等于前一天不持有股票且不处于冷冻期的最大利润
        return max(dp[n-1][3], dp[n-1][1], dp[n-1][2])  # 返回最后一天不持有股票的最大利润

```

> 版本二
```python
class Solution:
    def maxProfit(self, prices: List[int]) -> int:
        n = len(prices)
        if n < 2:
            return 0

        # 定义三种状态的动态规划数组
        dp = [[0] * 3 for _ in range(n)]
        dp[0][0] = -prices[0]  # 持有股票的最大利润
        dp[0][1] = 0           # 不持有股票，且处于冷冻期的最大利润
        dp[0][2] = 0           # 不持有股票，不处于冷冻期的最大利润

        for i in range(1, n):
            # 当前持有股票的最大利润等于前一天持有股票的最大利润或者前一天不持有股票且不处于冷冻期的最大利润减去当前股票的价格
            dp[i][0] = max(dp[i-1][0], dp[i-1][2] - prices[i])
            # 当前不持有股票且处于冷冻期的最大利润等于前一天持有股票的最大利润加上当前股票的价格
            dp[i][1] = dp[i-1][0] + prices[i]
            # 当前不持有股票且不处于冷冻期的最大利润等于前一天不持有股票的最大利润或者前一天处于冷冻期的最大利润
            dp[i][2] = max(dp[i-1][2], dp[i-1][1])

        # 返回最后一天不持有股票的最大利润
        return max(dp[-1][1], dp[-1][2])

```

> 版本三
```python
class Solution:
    def maxProfit(self, prices: List[int]) -> int:
        # 0: holding stocks 
        #    (1) keep holding stocks: dp[i][0] = dp[i - 1][0]
        #    (2) buy stocks: dp[i][0] = dp[i - 1][1] - price, or dp[i - 1][3] - price
        # 1: keep no stocks: dp[i][1] = dp[i - 1][1]
        # 2: sell stocks: dp[i][2] = dp[i - 1][0] + price
        # 3: cooldown day: dp[i][3] = dp[i - 1][2]
        dp = [-prices[0], 0, 0, 0]

        for price in prices[1:]:
            dc = dp.copy() # 这句话是关键，把前一天的 dp 状态保存下来，防止被覆盖掉，后面只用它，不用 dp，逻辑简单易懂
            dp[0] = max(
                dc[0],
                dc[1] - price,
                dc[3] - price
            )
            dp[1] = max(
                dc[1],
                dc[3]
            )
            dp[2] = dc[0] + price
            dp[3] = dc[2]

        return max(dp)
```

### Go：

```go
// 最佳买卖股票时机含冷冻期 动态规划
// 时间复杂度O(n) 空间复杂度O(n)
func maxProfit(prices []int) int {
    n := len(prices)
    if n < 2 {
        return 0
    }

    dp := make([][]int, n)
    status := make([]int, n * 4)
    for i := range dp {
        dp[i] = status[:4]
        status = status[4:]
    }
    dp[0][0] = -prices[0]
    
    for i := 1; i < n; i++ {
        dp[i][0] = max(dp[i - 1][0], max(dp[i - 1][1] - prices[i], dp[i - 1][3] - prices[i]))
        dp[i][1] = max(dp[i - 1][1], dp[i - 1][3])
        dp[i][2] = dp[i - 1][0] + prices[i]
        dp[i][3] = dp[i - 1][2]
    }
    
    return max(dp[n - 1][1], max(dp[n - 1][2], dp[n - 1][3]))
}

func max(a, b int) int {
    if a > b {
        return a
    }
    return b
}
```

```go
// 一维优化版本
// 时间复杂度O(n), 空间复杂度O(1)
func maxProfit(prices []int) int {
    
	// 0: 持有，一直持有和买入
	// 1: 不持有，一直不持有（不包含前一天卖出,因为这样的一天是冷静期，状态有区别）
	// 2：不持有，今天卖出
	// 3：冷静期，前一天卖出（一直不持有）
	dp0, dp1, dp2, dp3 := -prices[0], 0, 0, 0
    
	n := len(prices)
    
	for i := 1; i < n; i++ {
        t0 := max(dp0, max(dp1, dp3)-prices[i])
        t1 := max(dp1, dp3)
        t2 := dp0 + prices[i]
        t3 := dp2
        
        // 更新
		dp0, dp1, dp2, dp3 = t0, t1, t2, t3
	}
    
	return max(dp1, max(dp2, dp3))
}

func max(a, b int) int {
	if a > b {
		return a
	}
	return b
}
```



### JavaScript:

> 不同的状态定义 感觉更容易理解些
```javascript
function maxProfit(prices) {
  // 第i天状态 持股 卖出 非冷冻期(不持股) 处于冷冻期
  const dp = new Array(prices.length).fill(0).map(() => [0, 0, 0, 0]);
  dp[0][0] = -prices[0];
  for (let i = 1; i < prices.length; i++) {
    // 持股
    dp[i][0] = Math.max(dp[i - 1][0], dp[i - 1][2] - prices[i]);
    // 卖出
    dp[i][1] = dp[i - 1][0] + prices[i];
    // 非冷冻期（不持股）
    dp[i][2] = Math.max(dp[i - 1][2], dp[i - 1][1]);
    // 冷冻期（上一天卖出）
    dp[i][3] = dp[i - 1][1];
  }
  return Math.max(...dp.pop());
};
```

```javascript
const maxProfit = (prices) => {
    if(prices.length < 2) {
        return 0
    } else if(prices.length < 3) {
        return Math.max(0, prices[1] - prices[0]);
    }

    let dp = Array.from(Array(prices.length), () => Array(4).fill(0));
    dp[0][0] = 0 - prices[0];

    for(i = 1; i < prices.length; i++) {
        dp[i][0] = Math.max(dp[i - 1][0], Math.max(dp[i-1][1], dp[i-1][3]) - prices[i]);
        dp[i][1] = Math.max(dp[i -1][1], dp[i - 1][3]);
        dp[i][2] = dp[i-1][0] + prices[i];
        dp[i][3] = dp[i-1][2];
    }

    return Math.max(dp[prices.length - 1][1], dp[prices.length - 1][2], dp[prices.length - 1][3]);
};
```

```javascript
// 一维数组空间优化
const maxProfit = (prices) => {
  const n = prices.length
  const dp = new Array(4).fill(0)
  dp[0] = -prices[0]
  for (let i = 1; i < n; i ++) {
    const temp = dp[0] // 缓存上一次的状态
    const temp1 = dp[2]
    dp[0] = Math.max(dp[0], Math.max(dp[3] - prices[i], dp[1] - prices[i])) // 持有状态
    dp[1] = Math.max(dp[1], dp[3]) // 今天不操作且不持有股票
    dp[2] = temp + prices[i] // 今天卖出股票
    dp[3] = temp1 // 冷冻期
  }
  return Math.max(...dp)
};
```

### TypeScript：

> 版本一，与本文思路一致

```typescript
function maxProfit(prices: number[]): number {
    /**
        dp[i][0]: 持股状态；
        dp[i][1]: 无股状态，当天为非冷冻期；
        dp[i][2]: 无股状态，当天卖出；
        dp[i][3]: 无股状态，当天为冷冻期；
     */
    const length: number = prices.length;
    const dp: number[][] = new Array(length).fill(0).map(_ => []);
    dp[0][0] = -prices[0];
    dp[0][1] = dp[0][2] = dp[0][3] = 0;
    for (let i = 1; i < length; i++) {
        dp[i][0] = Math.max(
            dp[i - 1][0],
            Math.max(dp[i - 1][1], dp[i - 1][3]) - prices[i]
        );
        dp[i][1] = Math.max(dp[i - 1][1], dp[i - 1][3]);
        dp[i][2] = dp[i - 1][0] + prices[i];
        dp[i][3] = dp[i - 1][2];
    }
    const lastEl: number[] = dp[length - 1];
    return Math.max(lastEl[1], lastEl[2], lastEl[3]);
};
```

> 版本二，状态定义略有不同，可以帮助理解

```typescript
function maxProfit(prices: number[]): number {
    /**
        dp[i][0]: 持股状态，当天买入；
        dp[i][1]: 持股状态，当天未买入；
        dp[i][2]: 无股状态，当天卖出；
        dp[i][3]: 无股状态，当天未卖出；
        
        买入有冷冻期限制，其实就是状态[0]只能由前一天的状态[3]得到；
        如果卖出有冷冻期限制，其实就是[2]由[1]得到。
     */
    const length: number = prices.length;
    const dp: number[][] = new Array(length).fill(0).map(_ => []);
    dp[0][0] = -prices[0];
    dp[0][1] = -Infinity;
    dp[0][2] = dp[0][3] = 0;
    for (let i = 1; i < length; i++) {
        dp[i][0] = dp[i - 1][3] - prices[i];
        dp[i][1] = Math.max(dp[i - 1][1], dp[i - 1][0]);
        dp[i][2] = Math.max(dp[i - 1][0], dp[i - 1][1]) + prices[i];
        dp[i][3] = Math.max(dp[i - 1][3], dp[i - 1][2]);
    }
    return Math.max(dp[length - 1][2], dp[length - 1][3]);
};
```

### C:

```c
#define max(a, b) ((a) > (b) ? (a) : (b))

/**
 * 状态一：持有股票状态（今天买入股票，
 * 或者是之前就买入了股票然后没有操作，一直持有）
 * 不持有股票状态，这里就有两种卖出股票状态
 * 状态二：保持卖出股票的状态（两天前就卖出了股票，度过一天冷冻期。
 * 或者是前一天就是卖出股票状态，一直没操作）
 * 状态三：今天卖出股票
 * 状态四：今天为冷冻期状态，但冷冻期状态不可持续，只有一天！

 */
int maxProfit(int* prices, int pricesSize) {
    if(pricesSize == 0){
        return 0;
    }
    int dp[pricesSize][4];
    memset(dp, 0, sizeof (int ) * pricesSize * 4);
    dp[0][0] = -prices[0];
    for (int i = 1; i < pricesSize; ++i) {
        dp[i][0] = max(dp[i - 1][0], max(dp[i - 1][1] - prices[i], dp[i - 1][3] - prices[i]));
        dp[i][1] = max(dp[i - 1][1], dp[i - 1][3]);
        dp[i][2] = dp[i - 1][0] + prices[i];
        dp[i][3] = dp[i - 1][2];
    }
    return max(dp[pricesSize - 1][1], max(dp[pricesSize - 1][2], dp[pricesSize - 1][3]));
}
```



### Rust：

```rust
impl Solution {
    pub fn max_profit(prices: Vec<i32>) -> i32 {
        /*
         * dp[i][0]: 持股状态；
         * dp[i][1]: 无股状态，当天为非冷冻期；
         * dp[i][2]: 无股状态，当天卖出；
         * dp[i][3]: 无股状态，当天为冷冻期；
         */
        let mut dp = vec![vec![0; 4]; prices.len()];
        dp[0][0] = -prices[0];
        for (i, &p) in prices.iter().enumerate().skip(1) {
            dp[i][0] = dp[i - 1][0].max((dp[i - 1][3] - p).max(dp[i - 1][1] - p));
            dp[i][1] = dp[i - 1][1].max(dp[i - 1][3]);
            dp[i][2] = dp[i - 1][0] + p;
            dp[i][3] = dp[i - 1][2];
        }
        *dp[prices.len() - 1].iter().skip(1).max().unwrap()
    }
}
```



